/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.skills;

import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.api.common.attribute.IValueFormatter;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.skill.IDescriptionProvider;
import dev.toma.gunsrpg.common.attribute.Attribs;
import dev.toma.gunsrpg.common.skills.SimpleSkill;
import dev.toma.gunsrpg.common.skills.core.DescriptionContainer;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import java.util.Random;
import net.minecraft.util.text.ITextComponent;

public class MotherlodeSkill
extends SimpleSkill
implements IDescriptionProvider {
    private static final ChancesContainer[] DATA = new ChancesContainer[]{new ChancesContainer(0.1f, 0.0f), new ChancesContainer(0.2f, 0.0f), new ChancesContainer(0.35f, 0.0f), new ChancesContainer(0.5f, 0.15f), new ChancesContainer(0.65f, 0.25f)};
    private final DescriptionContainer container;
    private final int level;

    public MotherlodeSkill(SkillType<?> type, int level) {
        super(type);
        this.level = level;
        this.container = new DescriptionContainer(type);
        DATA[level - 1].appendInfo(this.container);
    }

    public int getDropMultiplier(Random random, IPlayerData data) {
        ChancesContainer container = DATA[this.level - 1];
        IAttributeProvider attributeProvider = data.getAttributes();
        float f = random.nextFloat() * attributeProvider.getAttribute(Attribs.MOTHERLODE_BONUS).floatValue();
        return f < container.trippleDrop ? 3 : (f - container.trippleDrop < container.doubleDrop ? 2 : 1);
    }

    @Override
    public ITextComponent[] supplyDescription(int desiredLineCount) {
        return this.container.getLines();
    }

    private static class ChancesContainer {
        private final float doubleDrop;
        private final float trippleDrop;

        public ChancesContainer(float doubleDrop, float trippleDrop) {
            this.doubleDrop = doubleDrop;
            this.trippleDrop = trippleDrop;
        }

        void appendInfo(DescriptionContainer container) {
            container.addProperty("double", IValueFormatter.PERCENT.formatAttributeValue(this.doubleDrop));
            if (this.trippleDrop > 0.0f) {
                container.addProperty("tripple", IValueFormatter.PERCENT.formatAttributeValue(this.trippleDrop));
            }
        }
    }
}

